<?php $this->assign('title', 'Reporte de Productos por Proveedor'); ?>

<?= $this->Form->create(null, ['type' => 'get', 'class' => 'mb-3']) ?>
<fieldset>
    <legend>Filtrar Reporte</legend>
    <div class="row">
        <div class="col">
            <?= $this->Form->control('start_date', [
                'type' => 'date',
                'label' => 'Fecha de Transacción (Inicio)',
                'class' => 'form-control',
                'value' => $startDate ?? ''
            ]) ?>
        </div>
        <div class="col">
            <?= $this->Form->control('end_date', [
                'type' => 'date',
                'label' => 'Fecha de Transacción (Fin)',
                'class' => 'form-control',
                'value' => $endDate ?? ''
            ]) ?>
        </div>
        <div class="col">
<?= $this->Form->control('proveedor_id', [
    'type' => 'select',
    'options' => $proveedores, // debe ser array tipo [id => nombre]
    'empty' => 'Seleccione Proveedor',
    'label' => 'Proveedor',
    'class' => 'form-control',
    'value' => $proveedorId ?? ''
]) ?>
        </div>
        <div class="col">
            <?= $this->Form->control('tipo_transaccion', [
                'type' => 'select',
                'options' => $tiposTransaccion,
                'empty' => 'Seleccione Tipo de Transacción',
                'label' => 'Tipo de Transacción',
                'class' => 'form-control',
                'value' => $tipoTransaccion ?? ''
            ]) ?>
        </div>
    </div>
</fieldset>

<?= $this->Form->button('Generar Reporte', ['class' => 'btn btn-primary mt-2', 'id' => 'generarReporteBtn']) ?>
<button type="button" class="btn btn-success mt-2" id="exportExcelBtn">Exportar a Excel</button>
<?= $this->Form->end() ?>


<h3 class="mt-4">Previsualización del Reporte</h3>
<iframe id="previewIframe" style="width: 100%; height: 600px; border: 1px solid #ccc;"></iframe>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Actualizar previsualización al cambiar filtros
        document.querySelector('form').addEventListener('submit', function (event) {
            event.preventDefault();
            const proveedorId = document.querySelector('select[name="proveedor_id"]').value;
            const tipoTransaccion = document.querySelector('select[name="tipo_transaccion"]').value;
            const startDate = document.querySelector('input[name="start_date"]').value;
            const endDate = document.querySelector('input[name="end_date"]').value;
    
            if (!startDate || !endDate) {
                alert('Por favor, ingrese ambas fechas: Fecha de Inicio y Fecha Fin.');
                return;
            }
    
            if (startDate > endDate) {
                alert('La Fecha de Inicio no puede ser mayor que la Fecha Fin.');
                return;
            }
    
            const url = `<?= $this->Url->build(['controller' => 'VistaReporteProductos', 'action' => 'exportarPdf']) ?>?proveedor_id=${proveedorId}&tipo_transaccion=${tipoTransaccion}&start_date=${startDate}&end_date=${endDate}`;
            document.getElementById('previewIframe').src = url;
        });
    
        // Exportar PDF
        document.getElementById('exportPdfBtn').addEventListener('click', function () {
            const proveedorId = document.querySelector('select[name="proveedor_id"]').value;
            const tipoTransaccion = document.querySelector('select[name="tipo_transaccion"]').value;
            const startDate = document.querySelector('input[name="start_date"]').value;
            const endDate = document.querySelector('input[name="end_date"]').value;
    
            if (!startDate || !endDate) {
                alert('Por favor, ingrese ambas fechas: Fecha de Inicio y Fecha Fin.');
                return;
            }
    
            const url = `<?= $this->Url->build(['controller' => 'VistaReporteProductos', 'action' => 'exportarPdf']) ?>?proveedor_id=${proveedorId}&tipo_transaccion=${tipoTransaccion}&start_date=${startDate}&end_date=${endDate}&download=1`;
            window.location.href = url;
        });
    });    
</script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.getElementById('exportExcelBtn').addEventListener('click', function (event) {
            event.preventDefault();
            const startDate = document.querySelector('input[name="start_date"]').value;
            const endDate = document.querySelector('input[name="end_date"]').value;
    
            if (!startDate || !endDate) {
                alert('Por favor, seleccione un rango de fechas antes de exportar.');
                return;
            }
    
            const form = document.querySelector('form');
            const formData = new FormData(form);
    
            const params = new URLSearchParams();
            for (const pair of formData) {
                params.append(pair[0], pair[1]);
            }
    
            const url = `<?= $this->Url->build(['controller' => 'VistaReporteProductos', 'action' => 'exportarExcel']) ?>?${params.toString()}`;
            window.location.href = url;
        });
    });    
</script>
