<?= $this->Flash->render('auth') ?>
<?= $this->Form->create() ?>


<div class="mb-3">
    <?= $this->Form->control('username', [
        'label' => false,
        'placeholder' => 'Correo electrónico',
        'class' => 'form-control py-3',
        'required' => true,
    ]) ?>
</div>
<div class="form-group">
<div class="mb-4">
    <?= $this->Form->control('password', [
        'label' => false,
        'placeholder' => 'Contraseña',
        'class' => 'form-control  py-3',
        'id' => 'passwordField',
        'required' => true,
    ]) ?>
    <button type="button" class="btn btn-secondary" id="togglePassword">
        👁
    </button>
</div>
</div>

<div class="text-center">
    <?= $this->Form->button(__('Ingresar'), ['class' => 'btn btn-info btn-lg w-100']) ?>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const passwordField = document.getElementById("passwordField");
        const togglePassword = document.getElementById("togglePassword");
    
        togglePassword.addEventListener("click", function () {
            if (passwordField.type === "password") {
                passwordField.type = "text";
                togglePassword.textContent = "🙈"; // Cambia el icono cuando se muestra
            } else {
                passwordField.type = "password";
                togglePassword.textContent = "👁"; // Cambia el icono cuando se oculta
            }
        });
    });
</script>