<?php $this->assign('title', 'Resumen del panel de Citas'); ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestin de Tratamientos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class= "">
    <div class="container-fluid mt-4 px-5">
        <div class="row">
            <div class="col-12 col-lg-4 mb-4">
                <div class="card shadow-sm border-0">
                    <div class="card-header">
                        <i class="fas fa-calendar-alt me-2"></i> Citas Creadas por Usuario (Hoy - Sin campanias)
                    </div>
                    <div class="card-body chart-container">
                        <canvas id="chartCitasPorUsuarioHoy"></canvas>
                    </div>
                </div>
            </div>
    
            <div class="col-12 col-lg-4 mb-4">
                <div class="card shadow-sm border-0">
                    <div class="card-header">
                        <i class="fas fa-chart-bar me-2"></i> Citas Creadas por Estado (Hoy - Sin campanias)
                    </div>
                    <div class="card-body chart-container">
                        <canvas id="chartCitasPorEstadoHoy"></canvas>
                    </div>
                </div>
            </div>
    
            <div class="col-12 col-lg-4 mb-4">
                <div class="card shadow-sm border-0">
                    <div class="card-header">
                        <i class="fas fa-chart-line me-2"></i> Citas Finalizadas  por Usuario (Mes Actual - Sin campanias)
                    </div>
                    <div class="card-body chart-container">
                        <canvas id="chartFinalizadasMensual"></canvas>
                    </div>
                </div>
            </div>
    
            <div class="col-12 col-lg-4 mb-4">
                <div class="card shadow-sm border-0">
                    <div class="card-header">
                        <i class="fas fa-user-friends me-2"></i> Pacientes Nuevos vs Frecuentes (Mes Actual)
                    </div>
                    <div class="card-body chart-container">
                        <canvas id="chartPacientesNuevosFrecuentes"></canvas>
                    </div>
                </div>
            </div>
    
            <div class="col-12 col-lg-4 mb-4">
                <div class="card shadow-sm border-0">
                    <div class="card-header">
                        <i class="fas fa-stopwatch me-2"></i> Tiempo Promedio entre Llegada e Inicio (Mes Actual)
                    </div>
                    <div class="card-body chart-container">
                        <canvas id="chartPromedioLlegadaInicio"></canvas>
                    </div>
                </div>
            </div>
            
            <div class="col-12 col-lg-4 mb-4">
                <div class="card shadow-sm border-0">
                    <div class="card-header">
                        <i class="fas fa-user-md me-2"></i> Citas Finalizadas por Doctor (Mes Actual)
                    </div>
                    <div class="card-body chart-container">
                        <canvas id="chartCitasFinalizadasPorDoctor"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<style>
canvas {
  width: 100%;
  height: auto;
}
.chart-container {
  position: relative;
  width: 100%;
}
.chart-container {
        position: relative;
        width: 100%;
        min-height: 300px;
    }

    @media (min-width: 992px) {
        .chart-container {
            min-height: 400px;
        }
    }
</style>

<script>
    const citasPorUsuarioHoy = <?= json_encode($citasPorUsuarioHoy) ?>;
    const citasPorEstadoHoy = <?= json_encode($citasPorEstadoHoy) ?>;
    const citasFinalizadasMensual = <?= json_encode($citasFinalizadasMensual) ?>;
    const ctxPacientes = document.getElementById('chartPacientesNuevosFrecuentes').getContext('2d');
    const citasFinalizadasPorDoctor = <?= json_encode($citasFinalizadasPorDoctor) ?>;
    // Grfico 1
    // Paleta fija de hasta 8 colores (puedes cambiarlos si deseas otros tonos)
    const coloresFijos = [
        'rgba(54, 162, 235, 0.6)',    // Azul
        'rgba(255, 99, 132, 0.6)',    // Rojo
        'rgba(255, 206, 86, 0.6)',    // Amarillo
        'rgba(75, 192, 192, 0.6)',    // Verde agua
        'rgba(153, 102, 255, 0.6)',   // Morado
        'rgba(255, 159, 64, 0.6)',    // Naranja
        'rgba(201, 203, 207, 0.6)',   // Gris claro
        'rgba(0, 200, 83, 0.6)',      // Verde
        'rgba(0, 123, 255, 0.6)',     // Azul oscuro
        'rgba(220, 53, 69, 0.6)',     // Rojo intenso
        'rgba(255, 193, 7, 0.6)',     // Amarillo dorado
        'rgba(40, 167, 69, 0.6)',     // Verde oscuro
        'rgba(108, 117, 125, 0.6)',   // Gris medio
        'rgba(102, 16, 242, 0.6)',    // Violeta fuerte
        'rgba(232, 62, 140, 0.6)',    // Rosa fuerte
        'rgba(13, 110, 253, 0.6)'     // Azul brillante
    ];


    const etiquetas = citasPorUsuarioHoy.map(item => item.user?.username ?? 'Desconocido');
    const datos = citasPorUsuarioHoy.map(item => item.total);

    // Asigna los colores fijos segn el orden
    const coloresAsignados = etiquetas.map((_, index) => coloresFijos[index % coloresFijos.length]);

    const ctx1 = document.getElementById('chartCitasPorUsuarioHoy').getContext('2d');
    new Chart(ctx1, {
        type: 'bar',
        data: {
            labels: etiquetas,
            datasets: [{
                label: 'Citas',
                data: datos,
                backgroundColor: coloresAsignados
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: { beginAtZero: true }
            }
        }
    });


    // Grfico 2
    const ctx2 = document.getElementById('chartCitasPorEstadoHoy').getContext('2d');
    new Chart(ctx2, {
        type: 'doughnut',
        data: {
            labels: citasPorEstadoHoy.map(item => item.estado),
            datasets: [{
                label: 'Citas',
                data: citasPorEstadoHoy.map(item => item.total),
                 backgroundColor: [
                    '#b38f00',   // pendiente
                    '#006400',   // confirmado
                    '#4b0082',   // en_consultorio
                    '#808080',   // finalizado
                    '#8b0000',   // cancelado
                    '#e67e22',   // en_recepcion
                    '#ff6384',   // programar
                    '#007b73',   // cabina
                    '#ff0000',   // sos
                    '#d4a320'    // citado
                ]

            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });

    // Grfico 3
    const etiquetas3 = citasFinalizadasMensual.map(item => item.user?.username ?? 'Desconocido');
    const datos3 = citasFinalizadasMensual.map(item => item.total);
    const coloresAsignados3 = etiquetas3.map((_, index) => coloresFijos[index % coloresFijos.length]);

    const ctx3 = document.getElementById('chartFinalizadasMensual').getContext('2d');
    new Chart(ctx3, {
        type: 'bar',
        data: {
            labels: etiquetas3,
            datasets: [{
                label: 'Finalizadas',
                data: datos3,
                backgroundColor: coloresAsignados3
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: { beginAtZero: true }
            }
        }
    });

    //grafico 4
    new Chart(ctxPacientes, {
        type: 'doughnut',
        data: {
            labels: ['Frecuentes', 'Nuevos'],
            datasets: [{
                data: [<?= h($pacientesFrecuentesCount) ?>, <?= h($pacientesNuevos) ?>],
                backgroundColor: ['rgba(255, 205, 86, 0.7)', 'rgba(75, 192, 192, 0.7)'],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top'
                },
                title: {
                    display: true,
                    text: 'Pacientes Nuevos vs Frecuentes del Mes'
                }
            }
        }
    });
    // grafico 5
    const ctx4 = document.getElementById('chartPromedioLlegadaInicio').getContext('2d');
    new Chart(ctx4, {
        type: 'bar',
        data: {
            labels: ['Promedio minutos'],
            datasets: [{
                label: 'Minutos',
                data: [<?= $promedioMinutos ?>],
                backgroundColor: 'rgba(255, 206, 86, 0.6)'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Grfico 6 - Citas Finalizadas por Doctor (Mensual)
    const ctx6 = document.getElementById('chartCitasFinalizadasPorDoctor').getContext('2d');
    const etiquetas6 = citasFinalizadasPorDoctor.map(item => item.doctor_nombre ?? 'Desconocido');

    const datos6 = citasFinalizadasPorDoctor.map(item => item.total);
    const coloresAsignados6 = etiquetas6.map((_, index) => coloresFijos[index % coloresFijos.length]);

    new Chart(ctx6, {
        type: 'bar',
        data: {
            labels: etiquetas6,
            datasets: [{
                label: 'Citas Finalizadas',
                data: datos6,
                backgroundColor: coloresAsignados6
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

</script>