<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil Paciente</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- <style>
        body {
            background-color: #2b2f36;
            color: #d1d1d1;
        }
        .profile-card {
            background-color: #3a3f48;
            padding: 20px;
            border-radius: 10px;
        }
        .tab-content, .form-section {
            background-color: #3a3f48;
            padding: 20px;
            border-radius: 10px;
        }
        .nav-tabs .nav-link {
            color: #d1d1d1;
            background-color: #2b2f36;
            border: none;
            border-radius: 5px;
            margin-right: 5px;
        }
        .nav-tabs .nav-link.active {
            background-color: #3a3f48;
            color: white;
        }
        .form-control {
            background-color: #2b2f36;
            border: 1px solid #555;
            color: white;
        }
        .table-bordered th, .table-bordered td {
            border: 1px solid #dddddd; /* Color de borde más claro */
        }
    </style> -->
    <style>
        body {
            background-color: #f8f9fa; /* fondo claro de Bootstrap */
            color: #212529; /* texto estándar Bootstrap */
        }
        .profile-card {
            background-color: #ffffff; /* blanco para tarjetas */
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.05); /* sombra sutil */
        }
        .tab-content, .form-section {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.05);
        }
        .nav-tabs .nav-link {
            color: #495057; /* texto gris oscuro */
            background-color: #e9ecef; /* gris claro */
            border: none;
            border-radius: 5px;
            margin-right: 5px;
        }
        .nav-tabs .nav-link.active {
            background-color: #ffffff;
            color: #212529;
            font-weight: 500;
        }
        .form-control {
            background-color: #ffffff;
            border: 1px solid #ced4da;
            color: #212529;
        }
        .table-bordered th, .table-bordered td {
            border: 1px solid #dee2e6;
        }
        /* .text-box {
    border: 1px solid #ced4da;
    border-radius: 0.375rem;
    padding: 0.75rem 1rem;
    white-space: pre-wrap;
    background-color: #fff;
    font-family: inherit;
    font-size: 1rem;
} */
    .text-formateado{
        white-space: pre-wrap;
        border: 1px solid #ccc;
        padding: 10px;
    }
    .sin-desborde{
        white-space: pre-line;
    }
.btn-purple {
    background-color: #6f42c1; /* Morado tipo Bootstrap (purple) */
    color: white;
}

.btn-purple:hover {
    background-color: #5a32a3;
    color:white;
}

    </style>

</head>


<body>
<div class="container mt-4">
<div class="profile-card d-flex flex-column flex-md-row align-items-center text-center text-md-left">
    <!-- Ícono -->
    <!-- <div class="mb-3 mb-md-0 mr-md-3 d-flex align-items-center justify-content-center bg-light rounded-circle" style="width: 100px; height: 100px;">
        <i class="fas fa-user text-secondary" style="font-size: 2.5rem;"></i>
    </div> -->
    <?php
        $iconoGenero = 'fa-user'; // Por defecto (no especificado o masculino)
        if (($paciente->historias_clinica->sexo ?? '') === 'F') {
            $iconoGenero = 'fa-female';
        } elseif (($paciente->historias_clinica->sexo ?? '') === 'M') {
            $iconoGenero = 'fa-user';
        }
    ?>
    <div class="mb-3 mb-md-0 mr-md-3 d-flex align-items-center justify-content-center bg-light rounded-circle" style="width: 100px; height: 100px;">
        <i class="fas <?= $iconoGenero ?> text-secondary" style="font-size: 2.5rem;"></i>
    </div>

    <!-- Info principal -->
    <div class="order-1 order-md-0 mb-3 mb-md-0">
        <h4 class="mb-0"><?= h($paciente->nombre) ?> <?= h($paciente->apellido) ?></h4>
        <p class="mb-0">Género: <?= ($paciente->historias_clinica->sexo ?? '') == 'M' ? 'Masculino' : (($paciente->historias_clinica->sexo ?? '') == 'F' ? 'Femenino' : 'No especificado') ?></p>
        <p class="mb-0">Edad: <?= h($paciente->historias_clinica->edad ?? '') ?></p>
        <!-- <p class="mb-0">Tto. Interes: <?= h($paciente->historias_clinica->tipo_orden ?? '') ?></p> -->
        <p class="mb-0">Teléfono: <?= h($paciente->telefono_celular) ?></p>
    </div>

    <!-- Reacciones adversas -->
    <div class="order-2 mt-3 mt-md-0 ml-md-auto text-center text-md-right">
        <h5>Reacciones adversas a medicamentos</h5>
        <p style="white-space: pre-line;"><?= h($paciente->historias_clinica->alergias ?? '') ?></p>
    </div>
</div>

   

    <!-- <ul class="nav nav-tabs mt-4">
        <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#datos">Datos administrativos</a></li>
        <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#antecedentes">Antecedentes médicos</a></li>
        <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#ficha">Ficha Clínica</a></li>
        <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#consultas">Consultas y Procedimientos</a></li>
    </ul>     -->
    <div class="mt-4 overflow-auto" style="white-space: nowrap;">
    <ul class="nav nav-tabs mt-4 flex-column flex-sm-row">
    <li class="nav-item">
        <a class="nav-link active text-center mb-2 mx-2" data-toggle="tab" href="#datos">Datos administrativos</a>
    </li>
    <li class="nav-item">
        <a class="nav-link text-center mb-2 mx-2" data-toggle="tab" href="#antecedentes">Antecedentes médicos</a>
    </li>
<?php if ($usuario->rol != 3): ?>
    <li class="nav-item">
        <a class="nav-link text-center mb-2 mx-2" data-toggle="tab" href="#ficha">Ficha Clínica</a>
    </li>
<?php endif; ?>
<?php if ($usuario->rol != 3): ?>
            <li class="nav-item">
                <a class="nav-link text-center mx-2" data-toggle="tab" href="#citas">Citas del Paciente</a>
            </li>
        <?php endif; ?>
    <li class="nav-item">
        <a class="nav-link text-center mx-2" data-toggle="tab" href="#consultas">Consultas y Procedimientos</a>
    </li>
</ul>



            <div class="tab-content mt-3">
        <!-- Pestaña 1: Datos administrativos -->
        <div id="datos" class="tab-pane fade show active">
    <div class="form-section">
        <?php if (!empty($paciente->historias_clinica)) : ?>
            <h5 class="mb-4 sin-desborde">INFORMACIÓN PERSONAL</h5>
            <div class="row">
                <div class="col-md-12 mb-2">
                    <label>Nombres</label>
                    <input type="text" class="form-control" value="<?= h($paciente->nombre) ?>" readonly>
                </div>
                <div class="col-md-12 mb-2">
                    <label>Apellidos</label>
                    <input type="text" class="form-control" value="<?= h($paciente->apellido) ?>" readonly>
                </div>
                <div class="col-md-6 mb-2">
                    <label>DNI/Carnet de extranjeria</label>
                    <input type="text" class="form-control" value="<?= h($paciente->historias_clinica->dni) ?>" readonly>
                </div>
                <div class="col-md-6 mb-2">
                    <label>Fecha de Nacimiento</label>
                    <input type="text" class="form-control" value="<?= h($paciente->historias_clinica->fecha_nacimiento) ?>" readonly>
                </div>
                <div class="col-md-6 mb-2">
                    <label>Sexo</label>
                    <input type="text" class="form-control" 
                        value="<?= $paciente->historias_clinica->sexo === 'M' ? 'Masculino' : ($paciente->historias_clinica->sexo === 'F' ? 'Femenino' : 'No especificado') ?>" 
                        readonly>
                </div>                    
                <div class="col-md-6 mb-2">
                    <label>Edad</label>
                    <input type="text" class="form-control" value="<?= h($paciente->historias_clinica->edad) ?>" readonly>
                </div>
                <div class="col-md-12 mb-2">
                    <label>Dirección</label>
                    <input type="text" class="form-control" value="<?= !empty($paciente->historias_clinica->departamento->nombre) ? h($paciente->historias_clinica->departamento->nombre) : '—' ?>" readonly>
                </div>
                <div class="col-md-12 mb-2">
                    <label>Ocupación</label>
                    <input type="text" class="form-control" value="<?= !empty($paciente->historias_clinica->ocupacion) ? h($paciente->historias_clinica->ocupacion) : '—' ?>" readonly>
                </div>
                <div class="col-md-12 mb-2">
                    <label>Teléfono Celular</label>
                    <input type="text" class="form-control" value="<?= !empty($paciente->telefono_celular) ? h($paciente->telefono_celular) : '—' ?>" readonly>
                </div>
            </div>

            <h5 class="mt-4 mb-4">INFORMACIÓN CRM</h5>
            <div class="row">
                <?php
                $campanas = [];

                if (!empty($paciente->citas)) {
                    foreach ($paciente->citas as $cita) {
                        if (!empty($cita->campana)) {
                            $campanas[] = h($cita->campana->nombre);
                        }
                    }
                }

                $campanasTexto = !empty($campanas) ? implode(' • ', $campanas) : 'N/A';
                ?>
                <div class="col-md-12 mb-2">
                    <label>Campañas</label>
                    <input type="text" class="form-control" value="<?= $campanasTexto ?>" readonly>
                </div>
                <div class="col-md-12 mb-2">
                      <label>Tto. de interes</label>
                        <input type="text" class="form-control" value="<?= h($paciente->historias_clinica->tipo_orden ?? '') ?>" readonly>
                    </div>
                    <div class="col-md-12 mb-2">
                        <label>Responsable</label>
                        <input type="text" class="form-control" value="<?= h($paciente->historias_clinica->user->username ?? '') ?>" readonly>
                    </div>
                    <div class="col-md-12 mb-2">
                        <label>Agendado por</label>
                        <input type="text" class="form-control" value="<?= h($paciente->historias_clinica->user->username ?? '') ?>" readonly>
                    </div>
                </div>
                <h5 class="mt-4 mb-4">OBS ADICIONALES - SOS</h5>
                <div class="row">
                    <div class="col-md-12 mb-2">
                        <input type="text" class="form-control" value="<?= !empty($paciente->historias_clinica->obs_administrativas) ? h($paciente->historias_clinica->obs_administrativas) : '&nbsp;' ?>" readonly>
                </div>
            </div>
        <?php else : ?>
            <p class="text-center sin-desborde">No hay historia clinica registrada para este paciente.</p>
            <div class="text-center mt-3">
                <?= $this->Html->link(
                    __('Agregar Historia Clínica'),
                    ['controller' => 'HistoriasClinicas', 'action' => 'add', $paciente->id],
                    ['class' => 'btn btn-info openModal', 'target' => '_blank']
                ) ?>
            </div>
        <?php endif; ?>
    </div>
</div>
        
        <!-- Pestaña 2: Antecedentes médicos -->
        <div id="antecedentes" class="tab-pane fade">
            <div class="form-section">
                <!-- <div class="card-header">
                    <h3>Historias Clínicas del Paciente</h3>
                </div> -->
                <div class="card-body">
                <h4 class="ml-3 sin-desborde">Antecedentes Médicos</h4>
                    <?php if (!empty($paciente->historias_clinica)) : ?>
                           
                            <div class="rounded p-3 mb-4">
                                <div class="row mb-3">
                                    <div class="col-md-2">
                                        <p class="label-text">Medicacion:</p>
                                    </div>
                                    <div class="col-md-10">
                                    <div class="text-formateado" ><?= h($paciente->historias_clinica->medicacion) ?></div>

                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-2">
                                        <p class="label-text" style="white-space: normal; word-break: break-word;">
                                            Reacciones adversas a medicamentos:
                                        </p>
                                    </div>
                                    <div class="col-md-10">
                                        <div class="text-formateado"><?= h($paciente->historias_clinica->alergias) ?></div>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-2">
                                        <p class="label-text">Enfermedades:</p>
                                    </div>
                                    <div class="col-md-10">
                                        <div class="text-formateado"><?= h($paciente->historias_clinica->enfermedades) ?></div>
                                    </div>
                                </div>
                                <!-- Boton para editar historia -->
                                <div class="text-center mt-3">
                                    <?= $this->Html->link(
                                        __('Editar Antecedentes'),
                                        ['controller' => 'HistoriasClinicas', 'action' => 'edit', $paciente->id],
                                        ['class' => 'btn btn-info openModal', 'target' => '_blank']
                                    ) ?>                        
                                </div>
                                
                                <!-- Examen Físico -->
<?php if ($usuario->rol != 3): ?>
<h4 class="mt-4 mb-4">Examen Físico</h4>
    <?php if (!empty($paciente->historias_clinica->examenes_fisicos)) : ?>
        <?php 
            // Obtener solo el último examen físico
            $ultimoExamenFisico = end($paciente->historias_clinica->examenes_fisicos); 
        ?>
        <div class="row mb-3">
            <div class="col-md-4">
                <p class="label-text">Edad:</p>
                <div class="form-control"><?= h($ultimoExamenFisico->edad) ?></div>
            </div>
            <div class="col-md-4">
                <p class="label-text">Peso (kg):</p>
                <div class="form-control"><?= h($ultimoExamenFisico->peso) ?></div>
            </div>
            <div class="col-md-4">
                <p class="label-text">Altura (cm):</p>
                <div class="form-control"><?= h($ultimoExamenFisico->altura) ?></div>
            </div>
            <div class="col-md-4">
                <p class="label-text">Temperatura (°C):</p>
                <div class="form-control"><?= h($ultimoExamenFisico->temperatura) ?></div>
            </div>
            <div class="col-md-4">
                <p class="label-text">Escala EVA:</p>
                <div class="form-control"><?= h($ultimoExamenFisico->eva) ?></div>
            </div>
            <div class="col-md-4">
                <p class="label-text">Presión Arterial:</p>
                <div class="form-control"><?= h($ultimoExamenFisico->presion) ?></div>
            </div>
            <div class="col-md-4">
                <p class="label-text">Frecuencia Cardíaca (bpm):</p>
                <div class="form-control"><?= h($ultimoExamenFisico->frecuencia_cardiaca) ?></div>
            </div>
            <div class="col-md-4">
                <p class="label-text">Saturación (%):</p>
                <div class="form-control"><?= h($ultimoExamenFisico->saturacion) ?></div>
            </div>
            <div class="col-md-4">
                <p class="label-text">Glicemia (mg/dL):</p>
                <div class="form-control"><?= h($ultimoExamenFisico->glicemina) ?></div>
            </div>
        </div>
        <!-- Botón para agregar un nuevo Examen Físico -->
                                <div class="text-center mt-4">
                                    <?= $this->Html->link(
                                        __('Agregar Examen Físico'),
                                        ['controller' => 'ExamenesFisicos', 'action' => 'add', $paciente->historias_clinica->id],
                                        ['class' => 'btn btn-info openModal', 'target' => '_blank']
                                    ) ?>
                                </div>
                                <!-- Botón para ver todas las historias de exámenes físicos -->
                                <div class="text-center mt-3">
                                    <?= $this->Html->link(
                                        __('Ver Historias'),
                                        ['controller' => 'FisicosHistorias', 'action' => 'index', '?' => ['historia_id' => $paciente->historias_clinica->id]],
                                        ['class' => 'btn btn-primary openModalXl', 'target' => '_blank']
                                    ) ?>
                                </div>
    <?php else : ?>
        <p class="text-center text-muted sin-desborde">No hay datos de examen físico registrados.</p>
    <?php endif; ?>
<?php endif; ?>
                            </div>
                            
                            <hr> <!-- Separador entre antecedentes -->
                    <?php else : ?>
                        <p class="text-center sin-desborde">No hay historia clínica registradas para este paciente.</p>
                        <div class="text-center mt-3">
                            <?= $this->Html->link(
                                __('Agregar Historia Clínica'),
                                ['controller' => 'HistoriasClinicas', 'action' => 'add', $paciente->id],
                                ['class' => 'btn btn-info openModal', 'target' => '_blank']
                            ) ?>                        
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Pestaña 3: Ficha Clínica -->
        <div id="ficha" class="tab-pane fade">
            <div class="form-section">
                <!-- Examen físico -->
<div class="row mb-3">
    <div class="col-12">
        <p class="section-title">Examen físico</p>
        <div class="p-3 border rounded">
            <?php 
            $examenes = [];
            if (!empty($paciente->historias_clinica)) {
                foreach ($paciente->historias_clinica->consultas as $consulta) {
                    if (!empty($consulta->examen_fisico)) {
                        $examenes[] = h($consulta->examen_fisico);
                    }
                }
            }
            ?>
            <?php if (!empty($examenes)): ?>
                <ul class="mb-0">
                    <?php foreach ($examenes as $examen): ?>
                        <li style="white-space: pre-line;"><?= $examen ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p class="mb-0 sin-desborde">No hay exámenes físicos registrados.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Órdenes médicas -->
<div class="row mb-3">
    <div class="col-12">
        <p class="section-title">Órdenes médicas</p>
        <div class="p-3 border rounded">
            <?php 
            $ordenesMedicas = [];
            if (!empty($paciente->historias_clinica)) {
                foreach ($paciente->historias_clinica->consultas as $consulta) {
                    if (!empty($consulta->orden_medico)) {
                        $ordenesMedicas[] = h($consulta->orden_medico);
                    }
                }
            }
            ?>
            <?php if (!empty($ordenesMedicas)): ?>
                <ul class="mb-0">
                    <?php foreach ($ordenesMedicas as $orden): ?>
                        <li style="white-space: pre-line;"><?= $orden ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p class="mb-0 sin-desborde">No hay órdenes médicas registradas.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Prescripciones -->
<div class="row mb-3">
    <div class="col-12">
        <p class="section-title">Prescripciones</p>
        <div class="p-3 border rounded">
            <?php 
            $prescripciones = [];
            if (!empty($paciente->historias_clinica)) {
                foreach ($paciente->historias_clinica->consultas as $consulta) {
                    if (!empty($consulta->prescripcion)) {
                        $prescripciones[] = h($consulta->prescripcion);
                    }
                }
            }
            ?>
            <?php if (!empty($prescripciones)): ?>
                <ul class="mb-0">
                    <?php foreach ($prescripciones as $prescripcion): ?>
                        <li style="white-space: pre-line;"><?= $prescripcion ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p class="mb-0 sin-desborde">No hay prescripciones registradas.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Diagnósticos CIE - 10 -->
<div class="row mb-3">
    <div class="col-12">
        <p class="section-title">Diagnósticos CIE - 10</p>
        <div class="p-3 border rounded">
            <?php 
            $diagnosticos = [];
            
            if (!empty($paciente->historias_clinica) && !empty($paciente->historias_clinica->consultas)) {
                foreach ($paciente->historias_clinica->consultas as $consulta) {
                    if (!empty($consulta->consultas_cie)) {
                        foreach ($consulta->consultas_cie as $consultaCie) {
                            if (!empty($consultaCie->diagnosticoscie10)) {
                                $diagnosticos[] = $consultaCie->diagnosticoscie10;
                            }
                        }
                    }
                }
            }
            ?>
                <?php if (!empty($diagnosticos)): ?>
                    <ul class="mb-0">
                        <?php foreach ($diagnosticos as $cie): ?>
                            <li style="white-space: pre-line;"><strong>CIE-10:</strong> <?= h($cie->clave) ?> <?= h($cie->descripcion) ?></li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <p class="mb-0 sin-desborde">No hay diagnósticos CIE-10 registrados.</p>
                <?php endif; ?>
        </div>
    </div>
</div>

        
                <!-- Archivos de las Historias Clínicas -->
                <?php if (!empty($paciente->historias_clinica)): ?>
                    <div class="mt-4">
                        <div class="card border-0">
                            <div class="card-header text-center">
                                <h4 style="white-space: pre-line;">Archivos de la Historia Clínica</h4>
                            </div>
                            <div class="card-body">
                                <div class="mb-3 text-center">
                                    <?= $this->Html->link(
                                        '+ Nuevo Documento',
                                        ['controller' => 'Documentos', 'action' => 'add', $paciente->historias_clinica->id],
                                        ['class' => 'btn btn-info openModal', 'target' => '_blank']
                                    ) ?>
                                </div>
        
                                <?php if (!empty($paciente->historias_clinica->documentos)): ?>
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Archivo</th>
                                                    <th>Tipo</th>
                                                    <th>Descripción</th>
                                                    <th>Fechas</th>
                                                    <th>Acción</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($paciente->historias_clinica->documentos as $archivo): ?>
                                                    <tr>
                                                        <td class="text-center text-secondary">
                                                            <?php
                                                                $esImagen = preg_match('/\.(jpg|jpeg|png|gif|webp)$/i', $archivo->ruta_archivo);
                                                                $ruta = $this->Url->assetUrl($archivo->ruta_archivo);
                                                                $icono = 'fa-file';
        
                                                                if (preg_match('/\.(pdf)$/i', $archivo->ruta_archivo)) {
                                                                    $icono = 'fa-file-pdf';
                                                                } elseif (preg_match('/\.(doc|docx)$/i', $archivo->ruta_archivo)) {
                                                                    $icono = 'fa-file-word';
                                                                } elseif (preg_match('/\.(xls|xlsx)$/i', $archivo->ruta_archivo)) {
                                                                    $icono = 'fa-file-excel';
                                                                } elseif (preg_match('/\.(ppt|pptx)$/i', $archivo->ruta_archivo)) {
                                                                    $icono = 'fa-file-powerpoint';
                                                                }
                                                            ?>
                                                            <div class="d-flex align-items-center justify-content-center" style="width: 90px; height: 60px; overflow: hidden;">
                                                                <?php if ($esImagen): ?>
                                                                    <img src="<?= $ruta ?>" alt="Documento" class="img-fluid" style="height: 60px; width: auto;">
                                                                <?php else: ?>
                                                                    <i class="fas <?= $icono ?> text-secondary" style="font-size: 2rem;"></i>
                                                                <?php endif; ?>
                                                            </div>
                                                        </td>
                                                        <td><?= h($archivo->tipo) ?></td>
                                                        <td><?= h($archivo->descripcion) ?></td>
                                                        <td>
                                                            <strong>Creado:</strong> <?= h($archivo->created->format('d-m-Y')) ?><br>
                                                            <strong>Modificado:</strong> <?= h($archivo->modified->format('d-m-Y')) ?>
                                                        </td>
                                                        <td class="text-center">
                                                            <a href="<?= $this->Url->build(['controller' => 'Documentos', 'action' => 'view', $archivo->id]) ?>" class="btn btn-info btn-sm openModal" target="_blank">
                                                                Ver Archivo
                                                            </a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <p class="text-center text-white sin-desborde">No hay documentos registrados en esta historia clínica.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        

        
<!-- Pestaña 4: Consultas y Procedimientos Juntos -->
<div id="consultas" class="tab-pane fade">
    <div class="form-section">
        <div class="d-flex flex-wrap justify-content-end align-items-center gap-2 mb-3">
            <?php if (!empty($paciente->historias_clinica)): ?>
                <?= $this->Html->link(
                    '+ Nuevo procedimiento',
                    ['controller' => 'Procedimientos', 'action' => 'add', $paciente->historias_clinica->id],
                    ['class' => 'btn btn-info openModal mx-2 mt-2 mt-md-0', 'target' => '_blank']
                ) ?>
                <?= $this->Html->link(
                    '+ Nueva consulta',
                    ['controller' => 'Consultas', 'action' => 'add', $paciente->historias_clinica->id],
                    ['class' => 'btn btn-info mx-2 mt-2 mt-md-0', 'target' => '_blank']
                ) ?>
            <?php endif; ?>
        </div>

        <?php
        $eventos = [];

        if (!empty($paciente->historias_clinica)) {
            foreach ($paciente->historias_clinica->consultas ?? [] as $consulta) {
                $eventos[] = [
                    'tipo' => 'consulta',
                    'created' => $consulta->created,
                    'data' => $consulta
                ];
            }

            foreach ($paciente->historias_clinica->procedimientos ?? [] as $procedimiento) {
                $eventos[] = [
                    'tipo' => 'procedimiento',
                    'created' => $procedimiento->created,
                    'data' => $procedimiento
                ];
            }

            usort($eventos, function ($a, $b) {
                return $b['created'] <=> $a['created'];
            });
        }
        ?>

        <?php if (!empty($eventos)): ?>
            <?php $counter = count($eventos); ?>
            <?php foreach ($eventos as $evento): ?>
                <?php if ($evento['tipo'] === 'consulta'): ?>
                    <?php $consulta = $evento['data']; ?>
                    <div class="card mb-3 p-3">
                        <div class="d-flex flex-column flex-md-row align-items-center">
                            <div class="mr-md-3 mb-3 mb-md-0">
                                <i class="fas fa-calendar-alt fa-3x"></i>
                            </div>
                            <div class="flex-fill mb-3 mb-md-0">
                                <h5 class="mb-0 text-break">
                                    Atención #<?= $counter ?>
                                    <small class="d-block text-muted" style="white-space: pre-line;"><?= h($consulta->motivo) ?></small>
                                </h5>
                                <p class="mb-1">
                                    <strong>Fecha:</strong> <?= h($consulta->created->format('d-m-Y')) ?><br>
                                    <strong>Especialista:</strong>
                                    <?= !empty($consulta->doctore)
                                        ? h($consulta->doctore->nombre . ' ' . $consulta->doctore->apellido)
                                        : '<span class="text-light">Sin doctor</span>' ?><br>
                                </p>
                            </div>
                            <div class="d-flex flex-column flex-md-row align-items-center justify-content-center flex-wrap">
                                <div class="mb-2 mx-2 w-auto w-md-auto">
                                    <?= $this->Html->link(
                                        '<i class="fas fa-pencil-alt"></i> Editar Consulta',
                                        ['controller' => 'Consultas', 'action' => 'edit', $consulta->id],
                                        ['class' => 'btn btn-info btn-sm openModal w-100 w-md-auto', 'target' => '_blank', 'escape' => false]
                                    ) ?>
                                </div>
                                <div class="mb-2 mx-2 w-auto w-md-auto">
                                    <?= $this->Html->link(
                                        '<i class="fas fa-eye"></i> Ver Consulta',
                                        ['controller' => 'Consultas', 'action' => 'view', $consulta->id],
                                        ['class' => 'btn btn-info btn-sm openModal w-100 w-md-auto', 'target' => '_blank', 'escape' => false]
                                    ) ?>
                                </div>
                                <div class="mb-2 mx-2 w-auto w-md-auto">
                                    <?= $this->Html->link(
                                        '<i class="fas fa-download"></i> Descargar Recetas',
                                        ['controller' => 'Consultas', 'action' => 'exportRecetasPdf', $consulta->id],
                                        ['class' => 'btn btn-info btn-sm w-100 w-md-auto', 'target' => '_blank', 'escape' => false]
                                    ) ?>
                                </div>
                                <div class="mb-2 mx-2 w-auto w-md-auto">
                                    <?= $this->Html->link(
                                        '<i class="fas fa-download"></i> Descargar Orden',
                                        ['controller' => 'Consultas', 'action' => 'exportConsultasPdf', $consulta->id],
                                        ['class' => 'btn btn-info btn-sm w-100 w-md-auto', 'target' => '_blank', 'escape' => false]
                                    ) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <?php $procedimiento = $evento['data']; ?>
                    <div class="card mb-3 p-3">
                        <div class="d-flex flex-column flex-md-row align-items-center">
                            <div class="mr-md-3 mb-3 mb-md-0">
                                <i class="fas fa-stethoscope fa-3x"></i>
                            </div>
                            <div class="flex-fill mb-3 mb-md-0">
                                <h5 class="mb-0 text-break">
                                    Procedimiento #<?= $counter ?>
                                    <small class="d-block text-muted" style="white-space: pre-line;">
                                        <?= h($procedimiento->procedimiento ?? 'Sin nombre') ?>
                                    </small>
                                </h5>
                                <p class="mb-1">
                                    <strong>Fecha:</strong> <?= h($procedimiento->created?->format('d-m-Y') ?? 'Sin fecha') ?><br>
                                    <strong>Doctor:</strong>
                                    <?= !empty($procedimiento->doctore)
                                        ? h($procedimiento->doctore->nombre . ' ' . $procedimiento->doctore->apellido)
                                        : '<span>Sin doctor</span>' ?><br>
                                </p>
                            </div>
                            <div class="d-flex flex-column flex-md-row align-items-center justify-content-center">
                                <div class="mb-2 mb-md-0 mr-md-2">
                                    <?= $this->Html->link(
                                        '<i class="fas fa-pencil-alt"></i> Editar Procedimiento',
                                        ['controller' => 'Procedimientos', 'action' => 'edit', $procedimiento->id],
                                        ['class' => 'btn btn-info btn-sm openModal', 'target' => '_blank', 'escape' => false]
                                    ) ?>
                                </div>
                                <div class="mb-2 mb-md-0 mr-md-2">
                                    <?= $this->Html->link(
                                        '<i class="fas fa-eye"></i> Ver Procedimiento',
                                        ['controller' => 'Procedimientos', 'action' => 'view', $procedimiento->id],
                                        ['class' => 'btn btn-info btn-sm openModal', 'target' => '_blank', 'escape' => false]
                                    ) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php $counter--; ?>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="text-center mt-5">
                <p class="sin-desborde"><i class="fas fa-exclamation-circle"></i> No hay atenciones ni procedimientos registrados.</p>
            </div>
        <?php endif; ?>
    </div> <!-- cierre de .form-section -->
</div>

<!-- pestaña 5: citas -->
<div id="citas" class="tab-pane fade">
    <div class="container mt-3">
        <div class="card shadow">
            <div class="card-header text-center">
                <h3>Citas del Paciente</h3>
            </div>
            <div class="card-body">
                <?php if (!empty($paciente->citas)) : ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered text-center align-middle">
                            <thead class="table">
                                <tr>
                                    <th>Doctor</th>
                                    <th>Fecha y Hora</th>
                                    <th>Tipo</th>
                                    <th>Estado</th>
                                    <th>Motivo</th>
                                    <th>Acción</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($paciente->citas as $cita): ?>
                                    <tr>
                                        <td>
                                            <?= !empty($cita->doctore) 
                                                ? h($cita->doctore->nombre . ' ' . $cita->doctore->apellido) 
                                                : 'No asignado' ?>
                                        </td>


                                        <td><?= h($cita->fecha_hora->format('d-m-Y H:i')) ?></td>
                                        <td>
                                            <?= h($cita->tipo === 'C' ? 'Consulta' : ($cita->tipo === 'P' ? 'Procedimiento' : '—')) ?>
                                        </td>

                                        <td><?= h($cita->estado) ?></td>
                                        <td style="max-width: 250px; word-wrap: break-word; white-space: normal;">
                                            <?= h($cita->motivo) ?>
                                        </td>

                                        <td>
                                            <?= $this->Html->link(
                                                'Ver',
                                                ['controller' => 'Citas', 'action' => 'view', $cita->id],
                                                ['class' => 'btn btn-sm btn-primary openModal']
                                            ) ?>
                                            <?= $this->Html->link(
                                                'Editar',
                                                ['controller' => 'Citas', 'action' => 'edit', $cita->id],
                                                ['class' => 'btn btn-sm btn-primary openModal']
                                            ) ?>
                                             <button 
                                                class="btn btn-sm btn-success marcar-hora-llegada" 
                                                data-cita-id="<?= $cita->id ?>"
                                                data-hora-llegada="<?= $cita->hora_llegada ? $cita->hora_llegada->format('H:i:s') : 'N/A' ?>"
                                                data-fecha-hora="<?= $cita->fecha_hora->format('Y-m-d H:i:s') ?>"
                                            >
                                                Hora llegada
                                                </button>
                                            <!-- Botón para cambiar a "en consultorio" -->
                                            <button 
                                                class="btn btn-sm btn-purple cambiar-estado" 
                                                data-cita-id="<?= $cita->id ?>" 
                                                data-estado="en_consultorio">
                                                En consultorio
                                            </button>

                                            <!-- Botón para cambiar a "en recepción" -->
                                            <button 
                                                class="btn btn-sm btn-warning cambiar-estado" 
                                                data-cita-id="<?= $cita->id ?>" 
                                                data-estado="en_recepcion">
                                                En recepción
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else : ?>
                    <p class="text-center">No hay citas registradas para este paciente.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
    </div>

    <div class="mt-5 text-center">
        <!-- Botón para descargar PDF -->
        <a href="<?= $this->Url->build(['action' => 'exportPacientePdf', $paciente->id]) ?>" class="btn btn-primary mb-3">
            Descargar PDF
        </a>
        <!-- Botón para volver -->
        <a href="<?= $this->Url->build(['action' => 'index']) ?>" class="btn btn-secondary me-2 mb-3">
            Volver
        </a>
        <!-- Botón Editar Odontograma -->
        <?= $this->Html->link(
                    __('Editar'),
                    ['action' => 'edit', $paciente->id],
                    ['class' => 'btn btn-info me-2 mb-3'] // Espaciado horizontal
                ) ?>
    </div>
</div>

<!-- Bootstrap JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Script para asegurar que las pestañas funcionen correctamente -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        var hash = window.location.hash;
        if (hash) {
            var tabTrigger = document.querySelector('a.nav-link[href="' + hash + '"]');
            if (tabTrigger) {
                $(tabTrigger).tab('show');
            }
        }
    });
</script>
</body>
</html>
<!-- para que la redireccion funcione -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const hash = window.location.hash;
        if (hash) {
            const tabTrigger = document.querySelector(`a.nav-link[href="${hash}"]`);
            if (tabTrigger) {
                const tab = new bootstrap.Tab(tabTrigger);
                tab.show();
            }
        }
    });
</script>

<script>
    $(document).on('click', '.marcar-hora-llegada', function (e) {
    e.preventDefault();

    const $btn = $(this);
    const citaId = $btn.data('cita-id');
    const horaLlegadaExistente = $btn.data('hora-llegada');
    const fechaHora = $btn.data('fecha-hora');

    const horaActual = new Date().toLocaleTimeString('it-IT'); // HH:mm:ss
    const fechaCita = fechaHora.split(' ')[0];

    // Fecha actual en Lima (UTC -5)
    const fechaActualLima = new Date();
    const fechaLimaFormateada = new Date(fechaActualLima.getTime() - (fechaActualLima.getTimezoneOffset() * 60000));
    const fechaActual = fechaLimaFormateada.toISOString().split('T')[0];

    if (fechaCita !== fechaActual) {
        alert('❌ Solo se puede marcar la hora de llegada para citas del día de hoy.');
        return;
    }

    if (horaLlegadaExistente && horaLlegadaExistente !== 'N/A') {
        const confirmar = confirm('⚠️ Esta cita ya tiene una hora de llegada registrada. ¿Desea actualizarla?');
        if (!confirmar) {
            return;
        }
    }

    $.ajax({
        url: '<?= $this->Url->build(["controller" => "Citas", "action" => "marcarHoraLlegada"]); ?>',
        type: 'POST',
        headers: {
            'X-CSRF-Token': '<?= $this->request->getAttribute("csrfToken"); ?>'
        },
        data: {
            cita_id: citaId,
            hora_llegada: horaActual
        },
        success: function(response) {
            alert('✅ Se registró la hora de llegada: ' + horaActual);
            window.location.href = window.location.pathname + '#citas';

        },
        error: function() {
            alert('❌ Error al registrar la hora de llegada.');
        }
    });
});

</script>
<script>
    $(document).on('click', '.cambiar-estado', function (e) {
        e.preventDefault();

        const citaId = $(this).data('cita-id');
        const nuevoEstado = $(this).data('estado');

        if (!citaId || !nuevoEstado) {
            alert('❌ No se pudo identificar la cita o el estado.');
            return;
        }

        $.ajax({
            url: '<?= $this->Url->build(['controller' => 'Citas', 'action' => 'changeStatus']); ?>',
            type: 'POST',
            headers: {
                'X-CSRF-Token': '<?= $this->request->getAttribute("csrfToken"); ?>'
            },
            data: { id: citaId, estado: nuevoEstado },
            success: function (response) {
                if (response.success) {
                    alert(`✅ Estado actualizado a: ${nuevoEstado.replace('_', ' ')}`);
                    window.location.href = window.location.pathname + '#citas';
                } else {
                    alert('❌ No se pudo actualizar el estado. Inténtalo de nuevo.');
                }
            },
            error: function () {
                alert('❌ Error al actualizar el estado.');
            }
        });
    });
</script>
<script>
    // Modal grande (openModal)
$('.openModal').on('click', function(e) {
    e.preventDefault();
    var url = $(this).attr('href');
    $.ajax({
        url: url,
        success: function(response) {
            $('#modalContentLg').html(response);
            
            // Abrir modal bloqueando clic fuera y ESC
            $('#modalLg').modal({
                backdrop: 'static',
                 // keyboard: false
            }).modal('show');

            initializePacienteSearch(); // Inicializar el buscador
        },
        error: function() {
            alert('Error al cargar el contenido para el modal grande.');
        }
    });
});

</script>

