<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Paciente $paciente
 * @var string[]|\Cake\Collection\CollectionInterface $departamentos
 * @var string[]|\Cake\Collection\CollectionInterface $campanas
 * @var string[]|\Cake\Collection\CollectionInterface $users
 */
?>
<div class="container mt-4 mb-4">
    <?= $this->Form->create($paciente, ['class' => 'row g-3']) ?>

    <div class="col-12 mb-4">
        <h3 class="text-info"><i class="fas fa-user-edit"></i> Editar Paciente</h3>
    </div>

    <div class="col-md-6 mb-3">
        <?= $this->Form->control('nombre', ['class' => 'form-control', 'label' => 'Nombre']) ?>
    </div>
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('apellido', ['class' => 'form-control', 'label' => 'Apellido']) ?>
    </div>
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('telefono_celular', ['class' => 'form-control', 'label' => 'Teléfono Celular', 'pattern' => '^[0-9]{1,22}$', 'maxlength' => '22' , 'title' => 'Solo se permiten números']) ?>
    </div>

<?php if (!empty($historiaClinica->id)) : ?>
<div class="col-md-6 mb-3">
    <?= $this->Form->control('historia_clinica.dni', ['class' => 'form-control', 'label' => 'DNI/Carnet de Extranjeria','value' => $paciente->historias_clinica->dni ?? '','pattern' => '^[0-9]{7,20}$', 'maxlength' => '20','inputmode' => 'numeric','title' => 'Solo se permiten números']) ?>
</div>
<div class="col-md-6 mb-3">
    <?= $this->Form->control('historia_clinica.fecha_nacimiento', ['class' => 'form-control', 'type' => 'date' ,'label' => 'Fecha de Nacimiento', 'id' => 'fecha-nacimiento', 'empty' => true, 'value' => $paciente->historias_clinica->fecha_nacimiento ?? '', 'max' => date('Y-m-d')]) ?>
</div>
<div class="col-md-6 mb-3">
    <?= $this->Form->control('historia_clinica.edad', ['class' => 'form-control', 'label' => 'Edad', 'value' => $paciente->historias_clinica->edad ?? '', 'id' => 'edad']) ?>
</div>
<div class="col-md-6 mb-3">
    <?= $this->Form->control('historia_clinica.departamento_id', ['options' => $departamentos, 'class' => 'form-control', 'label' => 'Procedencia', 'empty' => true, 'value' => $paciente->historias_clinica->departamento_id ?? '']) ?>
</div>
<div class="col-md-6 mb-3">
    <?= $this->Form->control('historia_clinica.sexo', [
        'type' => 'select',
        'options' => ['M' => 'Masculino', 'F' => 'Femenino'],
        'empty' => 'Seleccione...',
        'class' => 'form-control',
        'label' => 'Sexo',
        'default' => $paciente->historias_clinica->sexo ?? ''// Carga el valor actual del paciente
    ]); ?>
</div>
<div class="col-md-6 mb-3">
    <?= $this->Form->control('historia_clinica.tipo_orden', ['class' => 'form-control', 'label' => 'Tratamiento de interes', 'value' => $paciente->historias_clinica->tipo_orden ?? '']) ?>
</div>
<div class="col-md-6 mb-3">
    <?= $this->Form->control('historia_clinica.user_id', ['options' => $users, 'class' => 'form-control', 'label' => 'Usuario que registra', 'empty' => true, 'value' => $paciente->historias_clinica->user_id ?? '']) ?>
</div>
<div class="col-md-6 mb-3">
    <?= $this->Form->control('historia_clinica.como_entero', ['class' => 'form-control', 'label' => 'Como Enteró', 'value' => $paciente->historias_clinica->como_entero ?? '']) ?>
</div>
<div class="col-md-6 mb-3">
    <?= $this->Form->control('historia_clinica.ocupacion', ['class' => 'form-control', 'label' => 'Ocupación', 'value' => $paciente->historias_clinica->ocupacion ?? '']) ?>
</div>
<div class="col-md-6 mb-3">
    <?= $this->Form->control('historia_clinica.obs_administrativas', ['class' => 'form-control', 'label' => 'Observaciones Administrativas', 'value' => $paciente->historias_clinica->obs_administrativas ?? '']) ?>
</div>
    <div id="historia_clinica" class="container mt-4">
        <div class="card shadow">
            <div class="card-header text-center">
                <h3>Editar Historia Clínica</h3>
            </div>
            <div class="card-body">
                <div class="rounded p-3 mb-4 shadow-sm">
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <p class="label-text">Medicacion:</p>
                        </div>
                        <div class="col-md-10">
                            <?= $this->Form->control('historia_clinica.medicacion', [
                                'label' => false,
                                'class' => 'form-control',
                                'value' => $historiaClinica->medicacion
                            ]) ?>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <p class="label-text">Reacciones adversas a medicamentos:</p>
                        </div>
                        <div class="col-md-10">
                            <?= $this->Form->control('historia_clinica.alergias', [
                                'label' => false,
                                'class' => 'form-control',
                                'value' => $historiaClinica->alergias
                            ]) ?>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <p class="label-text">Enfermedades:</p>
                        </div>
                        <div class="col-md-10">
                            <?= $this->Form->control('historia_clinica.enfermedades', [
                                'label' => false,
                                'class' => 'form-control',
                                'value' => $historiaClinica->enfermedades
                            ]) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php else : ?>
    <p class="text-center text-muted">Este paciente no tiene una historia clínica registrada.</p>
<?php endif; ?>

    <div class="col-12 text-center mt-3">
        <?= $this->Form->button(__('Guardar Cambios'), ['type' => 'submit', 'class' => 'btn btn-primary']) ?>
        <?= $this->Html->link(__('Cancelar'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
    </div>

    <?= $this->Form->end() ?>
</div>

<script>
    document.getElementById('fecha-nacimiento').addEventListener('change', function() {
        var fechaNacimiento = new Date(this.value);
        var hoy = new Date();
        var edad = hoy.getFullYear() - fechaNacimiento.getFullYear();
        var mes = hoy.getMonth() - fechaNacimiento.getMonth();
    
        if (mes < 0 || (mes === 0 && hoy.getDate() < fechaNacimiento.getDate())) {
            edad--;
        }
    
        document.getElementById('edad').value = edad;
    });

    document.addEventListener("DOMContentLoaded", function() {
        const form = document.querySelector("form"); // Obtiene el formulario
        const btnGuardar = document.getElementById("btnGuardar");

        form.addEventListener("submit", function(event) {
            if (!form.checkValidity()) {
                event.preventDefault(); // Evita que el formulario se envíe si no es válido
                return;
            }
            btnGuardar.disabled = true;
            btnGuardar.innerText = "Guardando...";
        });
    });
</script>