<div class="container mt-4">
    <h3>Gestión de Horarios de Doctores</h3>

    <!-- Selectores -->
    <div class="form-group mt-3">
        <div class="row align-items-end">
            <div class="col-12 col-md-5 mb-2 mb-md-0">
                <label for="doctorSelect">Especialista:</label>
                <?= $this->Form->select('doctor_id', $doctores, [
                    'id' => 'doctorSelect',
                    'class' => 'form-control',
                    'empty' => '-- Seleccione un especialista --',
                    'value' => $doctorId
                ]) ?>
            </div>

            <div class="col-12 col-sm-6 col-md-4 mb-2 mb-md-0">
                <label for="datePicker">Seleccionar fecha de inicio:</label>
                <input type="date" id="datePicker" class="form-control" value="<?= h($fechaSeleccionada) ?>">
            </div>

            <div class="col-12 col-md-3 d-flex justify-content-md-end">
                <div class="d-flex w-100 justify-content-md-end" style="gap:.5rem;">
                    <button id="btnAddHorario" class="btn btn-primary btn-sm flex-fill">Agregar horario</button>
                    <button id="btnBulkMonth" class="btn btn-outline-primary btn-sm flex-fill">Mes siguiente</button>
                </div>
            </div>
        </div>
    </div>


    <!-- Selección rápida: toolbar -->
    <div id="selectionToolbar" style="display:none; position:sticky; top:0; z-index:1050; background:transparent; padding:6px 0;">
        <div class="d-flex justify-content-end align-items-center" style="gap:8px;">
            <div class="form-check form-check-inline mr-2">
                <input class="form-check-input" type="checkbox" id="includeOccupied">
                <label class="form-check-label small" for="includeOccupied">Incluir ocupadas</label>
            </div>
            <button id="clearSelectionBtn" class="btn btn-outline-secondary btn-sm">Limpiar selección</button>
            <button id="applySelectionBtn" class="btn btn-success btn-sm">Agregar horarios seleccionados</button>
            <button id="deleteSelectionBtn" class="btn btn-danger btn-sm">Eliminar horarios seleccionados</button>
        </div>
    </div>


    <hr>

    <?php
    setlocale(LC_TIME, 'es_ES.UTF-8');
    $formatter = new IntlDateFormatter('es_PE', IntlDateFormatter::FULL, IntlDateFormatter::NONE);
    $formatter->setPattern('EEEE d/MM');

    // Organizar horarios por fecha y normalizar horas a 'H:i' para comparaciones exactas
    $horariosPorDia = [];
    foreach ($horarios as $h) {
        $fecha = $h->fecha->format('Y-m-d');
        // Asegurar que hora_inicio/hora_fin estén en formato H:i y convertir a minutos desde medianoche
        $horaInicio = null;
        $horaFin = null;
        if (isset($h->hora_inicio) && $h->hora_inicio instanceof \DateTimeInterface) {
            $horaInicio = $h->hora_inicio->format('H:i');
        } else {
            $horaInicio = date('H:i', strtotime((string)($h->hora_inicio ?? '')));
        }
        if (isset($h->hora_fin) && $h->hora_fin instanceof \DateTimeInterface) {
            $horaFin = $h->hora_fin->format('H:i');
        } else {
            $horaFin = date('H:i', strtotime((string)($h->hora_fin ?? '')));
        }

        list($hiH, $hiM) = explode(':', $horaInicio) + [0,0];
        list($hfH, $hfM) = explode(':', $horaFin) + [0,0];
        $startMinutes = ((int)$hiH) * 60 + (int)$hiM;
        $endMinutes = ((int)$hfH) * 60 + (int)$hfM;

        $horariosPorDia[$fecha][] = [
            'start' => $horaInicio,
            'end' => $horaFin,
            'startMinutes' => $startMinutes,
            'endMinutes' => $endMinutes,
            'raw' => $h,
        ];
    }
    ?>

    <div class="table-responsive calendar-container">
        <table class="table table-bordered text-center">
            <thead>
                <tr>
                    <th>Hora</th>
                    <?php for ($i = 0; $i < 7; $i++):
                        $dia = (new DateTime($fechaSeleccionada))->modify("+$i days");
                    ?>
                        <th><?= ucfirst($formatter->format($dia)) ?></th>
                    <?php endfor; ?>
                </tr>
            </thead>
            <tbody>
                <?php for ($hour = 9; $hour <= 19; $hour++): ?>
                    <?php for ($minute = 0; $minute < 60; $minute += 15): ?>
                        <tr>
                            <td><?= date('H:i', strtotime("$hour:$minute")) ?></td>
                            <?php for ($i = 0; $i < 7; $i++): ?>
                                <?php
                                $fecha = (new DateTime($fechaSeleccionada))->modify("+$i days")->format('Y-m-d');
                                $horarioDisponible = false;
                                $cellTime = sprintf('%02d:%02d', $hour, $minute);
                                $matchedHorario = null;

                                if (!empty($horariosPorDia[$fecha])) {
                                    foreach ($horariosPorDia[$fecha] as $h) {
                                        $startMin = $h['startMinutes'];
                                        $endMin = $h['endMinutes'];
                                        // Comparar en minutos desde medianoche
                                        list($cH, $cM) = explode(':', $cellTime) + [0,0];
                                        $cellMin = ((int)$cH) * 60 + (int)$cM;

                                        if ($startMin <= $cellMin && $endMin > $cellMin) {
                                            $horarioDisponible = true;
                                            $matchedHorario = $h['raw'];
                                            break;
                                        }
                                    }
                                }
                                ?>
                                <td 
                                    class="horario-celda <?= $horarioDisponible ? 'ocupado' : '' ?>" 
                                    <?= $horarioDisponible ? 'draggable="true"' : '' ?>
                                    data-fecha="<?= $fecha ?>" 
                                    data-hora-inicio="<?= date('H:i', strtotime("$hour:$minute")) ?>" 
                                    data-hora-fin="<?= date('H:i', strtotime("$hour:$minute +15 minutes")) ?>"
                                    <?= $horarioDisponible && isset($matchedHorario->id) ? 'data-horario-id="'.h($matchedHorario->id).'"' : '' ?>
                                >
                                </td>
                            <?php endfor; ?>
                        </tr>
                    <?php endfor; ?>
                <?php endfor; ?>
            </tbody>
        </table>
    </div>
</div>

<style>
.horario-celda {
    height: 22px;
    padding: 2px 4px;
    cursor: pointer;
    font-size: 0.85rem;
    vertical-align: middle;
}
.horario-celda.ocupado {
    background-color: #5b70b3;
    color: white;
    font-weight: bold;
}
.horario-celda.selected {
    outline: 3px solid rgba(255,193,7,0.9); /* amber outline for selection */
    background-color: rgba(255,193,7,0.15);
}
.calendar-container {
    margin-top: 20px;
}
/* evitar selección de texto mientras se arrastra para seleccionar franjas */
.calendar-container, .calendar-container * {
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
}
/* Ajustes para tablas compactas */
.table.table-bordered td, .table.table-bordered th {
    padding: 4px 6px;
}

@media (max-width: 768px) {
    .horario-celda { height: 18px; font-size: 0.75rem; }
}

/* Date picker small width */
.small-date {
    display: inline-block;
    width: auto !important;
    min-width: 150px; /* ajusta según necesidad */
}
</style>
<!-- Toast container -->
<div aria-live="polite" aria-atomic="true" style="position: fixed; top: 1rem; right: 1rem; z-index: 2000;">
    <div id="horarioToast" class="toast" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3000" style="min-width: 220px; display:none;">
        <div class="toast-header">
            <strong class="mr-auto">Horarios</strong>
            <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="toast-body" id="horarioToastBody"></div>
    </div>
</div>

<style>
/* Toast tweaks */
.toast { opacity: 0.95; }
</style>
<?= $this->Html->meta('csrfToken', $this->request->getAttribute('csrfToken')); ?>

<!-- ✅ Script limpio -->
<script>
$(document).ready(function () {

    // Actualizar tabla al cambiar doctor o fecha
    $('#doctorSelect, #datePicker').on('change', function () {
        const doctorId = $('#doctorSelect').val();
        const fecha = $('#datePicker').val();
        if (doctorId && fecha) {
            window.location.href = `?doctor_id=${doctorId}&fecha=${fecha}`;
        }
    });

    // Doble clic para asignar horario
    $('.horario-celda').on('dblclick', function () {
        const cell = $(this);
        const fecha = cell.data('fecha');
        const horaInicio = cell.data('hora-inicio');
        const horaFin = cell.data('hora-fin');
        const doctorId = $('#doctorSelect').val();

        if (!doctorId) {
            alert('Seleccione un doctor primero.');
            return;
        }

        const esOcupado = cell.hasClass('ocupado');
        const accion = esOcupado ? 'eliminar' : 'asignar';

        $.ajax({
            url: `<?= $this->Url->build(['controller' => 'HorariosDoctores', 'action' => 'asignarHorario']) ?>`,
            method: 'POST',
            data: {
                fecha: fecha,
                hora_inicio: horaInicio,
                hora_fin: horaFin,
                doctor_id: doctorId,
                accion: accion
            },
            headers: {
                'X-CSRF-Token': $('meta[name="csrfToken"]').attr('content')
            },
            success: function (response) {
                if (response.success) {
                    // Repintar desde el servidor para reflejar el estado real sin recargar toda la página
                    refreshHorarios($('#doctorSelect').val(), $('#datePicker').val());
                } else {
                    alert(response.message || 'No se pudo guardar el horario.');
                }
            },
            error: function () {
                alert('Error de conexión con el servidor.');
            }
        });
    });

    // Utility: refrescar estado de horarios desde el servidor y repintar la tabla
    window.refreshHorarios = function(doctorId, fechaInicio) {
        if (!doctorId) return;
        $.ajax({
            url: `<?= $this->Url->build(['controller' => 'HorariosDoctores', 'action' => 'obtenerHorarios']) ?>`,
            method: 'GET',
            data: { doctor_id: doctorId },
            success: function (resp) {
                if (!resp.success) return;
                // Limpiar marcas previas
                $('.horario-celda').removeClass('ocupado').removeAttr('data-horario-id').attr('draggable', false);

                // Mapear horarios por fecha y marcar celdas
                function timeToMinutes(t) {
                    if (!t) return null;
                    // t can be 'HH:MM' or 'HH:MM:SS'
                    const parts = t.split(':');
                    const h = parseInt(parts[0] || '0', 10);
                    const m = parseInt(parts[1] || '0', 10);
                    return h * 60 + m;
                }

                resp.horarios.forEach(function (h) {
                    if (!h.fecha) return;
                    const hStart = timeToMinutes(h.hora_inicio);
                    const hEnd = timeToMinutes(h.hora_fin);
                    if (hStart === null || hEnd === null) return;

                    // Encontrar celdas con la misma fecha y dentro del rango
                    $('.horario-celda').each(function () {
                        const cell = $(this);
                        const cellFecha = cell.data('fecha');
                        if (cellFecha !== h.fecha) return;
                        const cellInicio = timeToMinutes(cell.data('hora-inicio'));
                        if (cellInicio === null) return;

                        // Comparar en minutos (inicio inclusivo, fin exclusivo)
                        if (cellInicio >= hStart && cellInicio < hEnd) {
                            cell.addClass('ocupado').attr('data-horario-id', h.id).attr('draggable', true);
                        }
                    });
                });
            },
            error: function () {
                console.warn('No se pudo obtener horarios para refrescar.');
            }
        });
    }

    // Drag & Drop: mover horarios
    let draggedHorario = null;

    // Reemplazar tbody mediante HTML parcial desde el servidor
    function replaceTbody(doctorId, fecha) {
        $.ajax({
            url: `<?= $this->Url->build(['controller' => 'HorariosDoctores', 'action' => 'partialTbody']) ?>`,
            method: 'GET',
            dataType: 'json',
            data: { doctor_id: doctorId, fecha: fecha },
            success: function(resp) {
                try {
                    if (!resp.success) throw new Error('No success');
                    // Reemplazar thead y tbody
                    $('table.table thead').replaceWith($(resp.thead));
                    $('table.table tbody').replaceWith($(resp.tbody));
                    showHorarioToast('Horarios actualizados.');
                } catch (e) {
                    console.warn('Error al reemplazar partes del calendario:', e);
                    location.reload();
                }
            },
            error: function() {
                console.warn('No se pudo obtener partes parciales, recargando.');
                location.reload();
            }
        });
    }

    // Toast helper (exposed to global so other script blocks can call it)
    window.showHorarioToast = function(message) {
        $('#horarioToastBody').text(message);
        const t = $('#horarioToast');
        t.show();
        t.toast('show');
        setTimeout(function(){ t.hide(); }, 3200);
    }

    $(document).on('dragstart', '.horario-celda.ocupado', function (e) {
        const el = $(this);
        draggedHorario = {
            id: el.data('horario-id') || null,
            fecha: el.data('fecha'),
            hora_inicio: el.data('hora-inicio'),
            hora_fin: el.data('hora-fin')
        };
        e.originalEvent.dataTransfer.setData('text/plain', JSON.stringify(draggedHorario));
        // Visual cue
        el.css('opacity', '0.6');
    });

    $(document).on('dragend', '.horario-celda.ocupado', function () {
        $(this).css('opacity', '');
        draggedHorario = null;
    });

    $(document).on('dragover', '.horario-celda', function (e) {
        e.preventDefault();
        $(this).addClass('drag-over');
    });

    $(document).on('dragleave', '.horario-celda', function () {
        $(this).removeClass('drag-over');
    });

    $(document).on('drop', '.horario-celda', function (e) {
        e.preventDefault();
        const target = $(this);
        target.removeClass('drag-over');

        if (!draggedHorario) {
            try {
                const data = JSON.parse(e.originalEvent.dataTransfer.getData('text/plain'));
                draggedHorario = data;
            } catch (err) {
                return;
            }
        }

        // No mover a la misma celda ni a otra ocupada
        const destFecha = target.data('fecha');
        const destInicio = target.data('hora-inicio');
        const destFin = target.data('hora-fin');
        const destOcupado = target.hasClass('ocupado');

        if (destOcupado) {
            alert('La celda destino ya está ocupada.');
            return;
        }

        // Confirmar movimiento
        if (!confirm('¿Mover este horario a la celda seleccionada?')) return;

        // Enviar petición mover
        $.ajax({
            url: `<?= $this->Url->build(['controller' => 'HorariosDoctores', 'action' => 'asignarHorario']) ?>`,
            method: 'POST',
            data: {
                accion: 'mover',
                horario_id: draggedHorario.id,
                doctor_id: $('#doctorSelect').val(),
                fecha: destFecha,
                hora_inicio: destInicio,
                hora_fin: destFin
            },
            headers: {
                'X-CSRF-Token': $('meta[name="csrfToken"]').attr('content')
            },
            success: function (response) {
                if (response.success) {
                    // Repintar solo las franjas para que el drag & drop se vea reflejado inmediatamente
                    refreshHorarios($('#doctorSelect').val(), $('#datePicker').val());
                } else {
                    alert(response.message || 'No se pudo mover el horario.');
                }
            },
            error: function () {
                alert('Error de conexión al mover el horario.');
            }
        });
    });

    // -------------------------
    // Selección múltiple con Ctrl+Click y toolbar
    // -------------------------
    // Toggle selection: Ctrl+click on a horario-celda (toggle single cell)
    $(document).on('click', '.horario-celda', function (e) {
        const isCtrl = e.ctrlKey || e.metaKey;
        if (!isCtrl) return; // keep normal click behaviour otherwise

        e.preventDefault();
        e.stopPropagation();
        const cell = $(this);
        // Respect includeOccupied checkbox: allow toggling occupied when checked
        const includeOccupied = $('#includeOccupied').is(':checked');
        if (cell.hasClass('ocupado') && !includeOccupied) return;
        cell.toggleClass('selected');

        // Show or hide toolbar depending on selection count
        const selectedCount = $('.horario-celda.selected').length;
        if (selectedCount > 0) {
            $('#selectionToolbar').show();
        } else {
            $('#selectionToolbar').hide();
        }
    });

    // --- Drag-to-select support ---
    let isDraggingSelection = false;
    let dragStartInfo = null; // { dateNum, minutes }

    function parseCellInfo(cell) {
        const fecha = $(cell).data('fecha');
        const hora = $(cell).data('hora-inicio');
        const parts = String(hora).split(':');
        const minutes = parseInt(parts[0]||0,10) * 60 + parseInt(parts[1]||0,10);
        const dateNum = new Date(fecha + 'T00:00:00').getTime();
        return { fecha: fecha, dateNum: dateNum, minutes: minutes };
    }

    function applyRectSelection(startInfo, currentInfo, actionSelect) {
        const minDate = Math.min(startInfo.dateNum, currentInfo.dateNum);
        const maxDate = Math.max(startInfo.dateNum, currentInfo.dateNum);
        const minMinutes = Math.min(startInfo.minutes, currentInfo.minutes);
        const maxMinutes = Math.max(startInfo.minutes, currentInfo.minutes);

        $('.horario-celda').each(function () {
            const c = $(this);
            const includeOccupiedArea = $('#includeOccupied').is(':checked');
            if (c.hasClass('ocupado') && !includeOccupiedArea) return; // skip occupied unless allowed
            const info = parseCellInfo(c);
            if (info.dateNum >= minDate && info.dateNum <= maxDate && info.minutes >= minMinutes && info.minutes <= maxMinutes) {
                if (actionSelect) c.addClass('selected'); else c.removeClass('selected');
            } else if (actionSelect === false) {
                // when deselecting via drag, ensure others remain intact
            }
        });
    }

    // Start selection on mousedown (left button) ONLY when Ctrl/Cmd is pressed (require modifier to begin drag)
    $(document).on('mousedown', '.horario-celda', function (e) {
        if (e.which !== 1) return; // left click only
        // Require Ctrl (or Cmd on Mac) to start drag selection. Without it, normal click behavior applies.
        if (!(e.ctrlKey || e.metaKey)) return;

        const cell = $(this);
        const includeOccupiedStart = $('#includeOccupied').is(':checked');
        if (cell.hasClass('ocupado') && !includeOccupiedStart) return; // don't start if occupied unless allowed

        e.preventDefault();
        isDraggingSelection = true;
        dragStartInfo = parseCellInfo(cell);

        // Determine action: if starting on an unselected cell -> select mode, otherwise deselect mode
        const startSelected = cell.hasClass('selected');
        const actionSelect = !startSelected;

        // Apply immediate single-cell action
        if (actionSelect) cell.addClass('selected'); else cell.removeClass('selected');
        $('#selectionToolbar').toggle($('.horario-celda.selected').length > 0);

        // Attach temporary handlers to expand selection during drag
        $(document).on('mouseenter.selection', '.horario-celda', function (ev) {
            if (!isDraggingSelection) return;
            const curInfo = parseCellInfo(this);
            applyRectSelection(dragStartInfo, curInfo, actionSelect);
            $('#selectionToolbar').toggle($('.horario-celda.selected').length > 0);
        });
    });

    // End drag selection on mouseup anywhere
    $(document).on('mouseup', function (e) {
        if (!isDraggingSelection) return;
        isDraggingSelection = false;
        dragStartInfo = null;
        // remove temporary mouseenter handler
        $(document).off('mouseenter.selection');
        $('#selectionToolbar').toggle($('.horario-celda.selected').length > 0);
    });

    // Clear selection
    $('#clearSelectionBtn').on('click', function () {
        $('.horario-celda.selected').removeClass('selected');
        $('#selectionToolbar').hide();
    });

    // Helper: group array of minute numbers (sorted) into contiguous ranges of 15min
    function buildRangesFromMinutes(minutesArr) {
        if (!minutesArr || minutesArr.length === 0) return [];
        minutesArr.sort(function(a,b){return a-b;});
        const ranges = [];
        let rangeStart = minutesArr[0];
        let prev = minutesArr[0];
        for (let i = 1; i < minutesArr.length; i++) {
            const cur = minutesArr[i];
            if (cur === prev + 15) {
                prev = cur;
                continue;
            }
            // end previous range (end is prev + 15)
            ranges.push({start: rangeStart, end: prev + 15});
            // start new
            rangeStart = cur;
            prev = cur;
        }
        // push last
        ranges.push({start: rangeStart, end: prev + 15});
        return ranges;
    }

    // Convert minutes from midnight to HH:MM string
    function minutesToTime(m) {
        const h = Math.floor(m / 60);
        const mm = m % 60;
        return String(h).padStart(2,'0') + ':' + String(mm).padStart(2,'0');
    }

    // On apply selection: gather selected cells, group by fecha, convert to ranges and POST per range
    $('#applySelectionBtn').on('click', function () {
        const selected = $('.horario-celda.selected').not('.ocupado'); // prefer only free cells
        if (selected.length === 0) {
            alert('No hay celdas libres seleccionadas.');
            return;
        }

        // Group minutes by fecha
        const byDate = {};
        selected.each(function () {
            const cell = $(this);
            const fecha = cell.data('fecha');
            const hora = cell.data('hora-inicio'); // 'HH:MM'
            const parts = String(hora).split(':');
            const minutes = parseInt(parts[0],10) * 60 + parseInt(parts[1]||0,10);
            if (!byDate[fecha]) byDate[fecha] = [];
            byDate[fecha].push(minutes);
        });

        // Build ranges
        const rangesToCreate = [];
        Object.keys(byDate).forEach(function(fecha){
            const mins = byDate[fecha];
            const ranges = buildRangesFromMinutes(mins);
            ranges.forEach(function(r){
                rangesToCreate.push({fecha: fecha, hora_inicio: minutesToTime(r.start), hora_fin: minutesToTime(r.end)});
            });
        });

        if (rangesToCreate.length === 0) return;

        // Confirm action
        if (!confirm('Crear ' + rangesToCreate.length + ' rango(s) de horarios seleccionados?')) return;

        const doctorId = $('#doctorSelect').val();
        if (!doctorId) { alert('Seleccione un doctor.'); return; }

        const csrf = $('meta[name="csrfToken"]').attr('content');

        // Send requests sequentially to avoid race conditions
        let idx = 0;
        function sendNext() {
            if (idx >= rangesToCreate.length) {
                // done
                $('#clearSelectionBtn').click();
                // refresh horario marks from server
                refreshHorarios(doctorId, $('#datePicker').val());
                showHorarioToast('Franjas creadas.');
                return;
            }
            const r = rangesToCreate[idx++];
            $.ajax({
                url: `<?= $this->Url->build(['controller' => 'HorariosDoctores', 'action' => 'asignarHorario']) ?>`,
                method: 'POST',
                data: {
                    accion: 'asignar',
                    doctor_id: doctorId,
                    fecha: r.fecha,
                    hora_inicio: r.hora_inicio,
                    hora_fin: r.hora_fin
                },
                headers: { 'X-CSRF-Token': csrf },
                success: function(resp) {
                    // ignore individual errors, continue
                    sendNext();
                },
                error: function() {
                    // continue anyway
                    sendNext();
                }
            });
        }

        sendNext();
    });

    // Delete selected occupied slots
    $('#deleteSelectionBtn').on('click', function () {
        const selected = $('.horario-celda.selected').filter('.ocupado');
        if (selected.length === 0) {
            alert('No hay celdas ocupadas seleccionadas para eliminar.');
            return;
        }

        if (!confirm('Eliminar ' + selected.length + ' franjas seleccionadas? Esta acción no se puede deshacer.')) return;

        const doctorId = $('#doctorSelect').val();
        if (!doctorId) { alert('Seleccione un doctor.'); return; }
        const csrf = $('meta[name="csrfToken"]').attr('content');

        // Build array of {fecha, hora_inicio}
        const items = [];
        selected.each(function () {
            const c = $(this);
            const fecha = c.data('fecha');
            const hora = c.data('hora-inicio');
            // Only include if it has horario id or clearly occupied
            if (hora) items.push({fecha: fecha, hora_inicio: hora});
        });

        let idxDel = 0;
        function sendDeleteNext() {
            if (idxDel >= items.length) {
                    $('#clearSelectionBtn').click();
                    // After deleting selected slots, reload to reflect changes
                    const params = new URLSearchParams(window.location.search);
                    params.set('doctor_id', doctorId);
                    // keep current fecha (so calendar stays where user is)
                    const fechaActual = $('#datePicker').val() || params.get('fecha') || new Date().toISOString().slice(0,10);
                    params.set('fecha', fechaActual);
                    window.location.search = params.toString();
                    // show toast after reload (toast may not be visible if page navigates)
                    // fallback: in case reload prevented, show toast
                    try { showHorarioToast('Franjas eliminadas.'); } catch(e){}
                    return;
                }
            const it = items[idxDel++];
            $.ajax({
                url: `<?= $this->Url->build(['controller' => 'HorariosDoctores', 'action' => 'asignarHorario']) ?>`,
                method: 'POST',
                data: {
                    accion: 'eliminar',
                    doctor_id: doctorId,
                    fecha: it.fecha,
                    hora_inicio: it.hora_inicio,
                    hora_fin: it.hora_inicio // hora_fin not used for eliminar but keep shape
                },
                headers: { 'X-CSRF-Token': csrf },
                success: function (resp) {
                    // continue even if errors
                    sendDeleteNext();
                },
                error: function () {
                    sendDeleteNext();
                }
            });
        }

        sendDeleteNext();
    });
});
</script>

<!-- Modal: Bulk modify month -->
<div class="modal" tabindex="-1" role="dialog" id="modalBulkMonth">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Modificar mes siguiente (Horarios)</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="formBulkMonth">
                    <div class="form-group">
                        <label>Acción</label>
                        <div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="action" id="actionEnable" value="enable" checked>
                                <label class="form-check-label" for="actionEnable">Habilitar horarios</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="action" id="actionDelete" value="delete">
                                <label class="form-check-label" for="actionDelete">Eliminar horarios</label>
                            </div>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="bulkHoraInicio">Hora inicio</label>
                            <input type="time" id="bulkHoraInicio" class="form-control" value="09:00" step="900">
                        </div>
                        <div class="form-group col-6">
                            <label for="bulkHoraFin">Hora fin</label>
                            <input type="time" id="bulkHoraFin" class="form-control" value="20:00" step="900">
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Días de la semana</label>
                        <div class="d-flex flex-wrap" style="gap:8px;">
                            <label class="form-check"><input type="checkbox" class="bulk-day" value="1" checked> Lun</label>
                            <label class="form-check"><input type="checkbox" class="bulk-day" value="2" checked> Mar</label>
                            <label class="form-check"><input type="checkbox" class="bulk-day" value="3" checked> Mié</label>
                            <label class="form-check"><input type="checkbox" class="bulk-day" value="4" checked> Jue</label>
                            <label class="form-check"><input type="checkbox" class="bulk-day" value="5" checked> Vie</label>
                            <label class="form-check"><input type="checkbox" class="bulk-day" value="6"> Sáb</label>
                            <label class="form-check"><input type="checkbox" class="bulk-day" value="0"> Dom</label>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="bulkSkipIfCitas" checked>
                            <label class="form-check-label" for="bulkSkipIfCitas">No eliminar franjas si hay citas (skipear)</label>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="bulkOmitLunch" checked>
                            <label class="form-check-label" for="bulkOmitLunch">Omitir descanso 13:00 - 15:00</label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="bulkApply">Ejecutar</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<script>
$(function(){
    // Open modal
    $('#btnBulkMonth').on('click', function(){
        const doctorId = $('#doctorSelect').val();
        if (!doctorId) { alert('Seleccione un doctor primero.'); return; }
        $('#modalBulkMonth').modal('show');
    });

    // Submit bulk action
    $('#bulkApply').on('click', function(){
        const doctorId = $('#doctorSelect').val();
        if (!doctorId) { alert('Seleccione un doctor.'); return; }
        const action = $('input[name="action"]:checked').val();
        const horaInicio = $('#bulkHoraInicio').val();
        const horaFin = $('#bulkHoraFin').val();
        const days = [];
        $('.bulk-day:checked').each(function(){ days.push($(this).val()); });
        if (days.length === 0) { if (!confirm('No ha seleccionado días. ¿Desea aplicar a todos los días del mes siguiente?')) return; }
        const skipIfCitas = $('#bulkSkipIfCitas').is(':checked');

        $('#modalBulkMonth').modal('hide');

        $.ajax({
            url: `<?= $this->Url->build(['controller' => 'HorariosDoctores', 'action' => 'bulkModifyMonth']) ?>`,
            method: 'POST',
            dataType: 'json',
                data: {
                    doctor_id: doctorId,
                    action: action,
                    hora_inicio: horaInicio,
                    hora_fin: horaFin,
                    days: days,
                    skip_if_citas: skipIfCitas ? 1 : 0,
                    omit_lunch: $('#bulkOmitLunch').is(':checked') ? 1 : 0
                },
            headers: { 'X-CSRF-Token': $('meta[name="csrfToken"]').attr('content') },
            success: function(resp){
                if (!resp || !resp.success) {
                    alert(resp && resp.message ? resp.message : 'Ocurrió un error.');
                    return;
                }
                let msg = '';
                if (resp.created !== undefined) msg += 'Creados: ' + resp.created + '. ';
                if (resp.deleted !== undefined) msg += 'Eliminados: ' + resp.deleted + '. ';
                if (resp.skipped !== undefined) msg += 'Omitidos: ' + resp.skipped + '. ';
                showHorarioToast(msg || 'Operación completada.');
                // Recargar la página actual para que el usuario vea inmediatamente el estado actualizado
                // Dejamos un pequeño retardo para que el toast se muestre brevemente
                setTimeout(function(){
                    location.reload();
                }, 600);
            },
            error: function(xhr){
                alert('Error del servidor al procesar la operación.');
            }
        });
    });
});
</script>

<!-- Modal: Agregar Horario -->
<div class="modal" tabindex="-1" role="dialog" id="modalAddHorario">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar horario</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="formAddHorario">
                    <div class="form-group">
                        <label for="addFecha">Fecha</label>
                        <input type="date" id="addFecha" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="addHoraInicio">Hora inicio</label>
                        <input type="time" id="addHoraInicio" class="form-control" step="900" required>
                    </div>
                    <div class="form-group">
                        <label for="addHoraFin">Hora fin</label>
                        <input type="time" id="addHoraFin" class="form-control" step="900" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="saveAddHorario">Guardar</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<script>
$(function(){
        // Abrir modal al clickear el botón
        $('#btnAddHorario').on('click', function(){
                const fecha = $('#datePicker').val() || '<?= h($fechaSeleccionada) ?>';
                $('#addFecha').val(fecha);
                $('#addHoraInicio').val('09:00');
                $('#addHoraFin').val('09:15');
                $('#modalAddHorario').modal('show');
        });

        $('#saveAddHorario').on('click', function(){
                const doctorId = $('#doctorSelect').val();
                if (!doctorId) { alert('Seleccione un doctor primero.'); return; }
                const fecha = $('#addFecha').val();
                const horaInicio = $('#addHoraInicio').val();
                const horaFin = $('#addHoraFin').val();

                if (!fecha || !horaInicio || !horaFin) { alert('Complete todos los campos.'); return; }
                if (horaInicio >= horaFin) { alert('La hora de fin debe ser posterior a la de inicio.'); return; }

                $.ajax({
                        url: `<?= $this->Url->build(['controller' => 'HorariosDoctores', 'action' => 'asignarHorario']) ?>`,
                        method: 'POST',
                        data: {
                                accion: 'asignar',
                                doctor_id: doctorId,
                                fecha: fecha,
                                hora_inicio: horaInicio,
                                hora_fin: horaFin
                        },
                        headers: { 'X-CSRF-Token': $('meta[name="csrfToken"]').attr('content') },
                        success: function(resp){
                                if (resp.success) {
                                            $('#modalAddHorario').modal('hide');
                                            // Redirigir a la vista comenzando desde la fecha guardada
                                            const params = new URLSearchParams(window.location.search);
                                            params.set('doctor_id', doctorId);
                                            params.set('fecha', fecha);
                                            window.location.search = params.toString();
                                        } else {
                                            alert(resp.message || 'No se pudo agregar el horario.');
                                        }
                        },
                        error: function(){ alert('Error de conexión al agregar horario.'); }
                });
        });
});
</script>
