<div class="container mt-4">
    <h2 class="mb-3 text-info">Nueva Consulta</h2>
    
    <?= $this->Form->create($consulta, ['type' => 'file', 'class' => 'needs-validation']) ?>
    <div class="mb-3">
        <?= $this->Form->control('paciente_id', [
            'label' => 'Paciente',
            'options' => $pacientes,
            'empty' => 'Seleccione un paciente',
            'class' => 'form-control',
            'disabled' => ($consulta->paciente_id) ? true : false
        ]) ?>
    </div>    
    <div class="row">     
        <div class="col-md-12">
            <?= $this->Form->control('motivo', ['label' => 'Motivo de consulta', 'class' => 'form-control mb-2']) ?>
            <?= $this->Form->control('examen_fisico', ['label' => 'Examen fisico', 'class' => 'form-control mb-2']) ?>
            <?= $this->Form->control('diagnostico', ['label' => 'Diagnostico', 'class' => 'form-control mb-2']) ?>
        </div>
        <div class="col-md-12">         
            <div class="mb-3 position-relative">
                <label for="cie-search">CIE-10</label>
                <input type="text" id="cie-search" class="form-control" placeholder="Escribe para buscar..." autocomplete="off">
                
                <div id="cie-suggestions" class="list-group position-absolute w-100" style="display: block; z-index: 1000; overflow-y: auto;"></div>
            </div>
            
            <div id="selected-cies"></div>
            <!-- Campo de usuario oculto -->
            <?= $this->Form->hidden('user_id', ['value' => $usuario->id]) ?>
            
            <!-- Nuevo campo para seleccionar el doctor -->
<?php
if ($usuario->rol == 3 && !empty($consulta->doctor_id)) {
    echo $this->Form->control('doctor_id', [
        'type' => 'hidden',
        'value' => $consulta->doctor_id
    ]);
} else {
    echo $this->Form->control('doctor_id', [
        'label' => 'Doctor',
        'options' => $doctores,
        'class' => 'form-control mb-2',
        'empty' => 'Seleccione un doctor'
    ]);
}
?>
        </div>
        <div class="col-md-12">
            <?= $this->Form->control('prescripcion', ['label' => 'Prescripción', 'class' => 'form-control mb-2']) ?>

            
            <?= $this->Form->control('orden_medico', ['label' => 'Orden Médica', 'class' => 'form-control mb-2']) ?>
            <div class="col-md-14 mx-auto mb-3">
                <?= $this->Form->control('documentos_temp', [
                    'type' => 'file',
                    'label' => 'Agregar Documento',
                    'class' => 'form-control',
                    'id' => 'documentosTemp',
                    'multiple' => true,
                ]) ?>
            </div>
            
            <!-- Lista visual de archivos -->
            <div class="col-md-14 mx-auto mb-3">
                <label>Archivos seleccionados:</label>
                <ul id="lista-documentos" class="list-group"></ul>
            </div>
            
            <!-- Campo oculto real que se enviará -->
            <input type="file" name="documentos[]" id="documentosFinal" style="display:none;" multiple>            
    </div>

    <div class="col-12 text-center mt-3 mb-2">
        <?= $this->Form->button(__('Guardar Consulta'), ['class' => 'btn btn-primary']) ?>
<?php if (!empty($historia)): ?>
    <?= $this->Html->link(__('Cancelar'), ['controller' => 'Pacientes', 'action' => 'view', $historia->paciente_id], ['class' => 'btn btn-secondary']) ?>
<?php else: ?>
    <?= $this->Html->link(__('Cancelar'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
<?php endif; ?>
    </div>
    
    <?= $this->Form->end() ?>
</div>
<script>
    var initializeFormLogic = (context) => {
        if (context.dataset.formLogicInitialized) return;
        context.dataset.formLogicInitialized = true;
        console.log("initializeFormLogic ejecutado en:", context);

        const inputTemp = context.querySelector('#documentosTemp');
        const inputFinal = context.querySelector('#documentosFinal');
        const lista = context.querySelector('#lista-documentos');

        if (!inputTemp || !inputFinal || !lista) return;

        let archivosSeleccionados = [];

inputTemp.addEventListener('change', function () {
    const nuevosArchivos = Array.from(this.files);
    if (!nuevosArchivos.length) return;

    nuevosArchivos.forEach(nuevoArchivo => {
        if (archivosSeleccionados.some(file => file.name === nuevoArchivo.name)) {
            // Evita duplicados por nombre (opcional, podrías usar algo más robusto si quieres)
            console.warn("Archivo duplicado:", nuevoArchivo.name);
            return;
        }

        archivosSeleccionados.push(nuevoArchivo);
    });

    actualizarListaVisual();
    actualizarInputFinal();

    // Resetea el input para poder volver a subir los mismos archivos si se desea
    inputTemp.value = '';
});


        function actualizarListaVisual() {
            lista.innerHTML = '';
            archivosSeleccionados.forEach((file, index) => {
                const li = document.createElement('li');
                li.className = 'list-group-item d-flex justify-content-between align-items-center';
                li.textContent = file.name;

                const btnEliminar = document.createElement('button');
                btnEliminar.textContent = 'x';
                btnEliminar.className = 'btn btn-sm btn-danger';
                btnEliminar.onclick = function () {
                    archivosSeleccionados.splice(index, 1);
                    actualizarListaVisual();
                    actualizarInputFinal();
                };

                li.appendChild(btnEliminar);
                lista.appendChild(li);
            });
        }

        function actualizarInputFinal() {
            const dataTransfer = new DataTransfer();
            archivosSeleccionados.forEach(file => dataTransfer.items.add(file));
            inputFinal.files = dataTransfer.files;
        }
    };


    function initializeCieSearch(context) {
        if (context.dataset.cieLogicInitialized) return;
        context.dataset.cieLogicInitialized = true;
        console.log("initializeCieSearch ejecutado en:", context);

        const searchInput = context.querySelector("#cie-search");
        const suggestionsList = context.querySelector("#cie-suggestions");
        const selectedCies = context.querySelector("#selected-cies");

        if (!searchInput || !suggestionsList || !selectedCies) {
            console.warn("Elementos de búsqueda CIE no encontrados en:", context);
            return;
        }

        searchInput.addEventListener("input", function () {
            const query = searchInput.value.trim().toLowerCase();

            if (query.length < 2) {
                suggestionsList.style.display = "none";
                return;
            }

            fetch("<?= $this->Url->build(['controller' => 'Consultas', 'action' => 'buscarCie']) ?>?q=" + encodeURIComponent(query))
                .then(response => response.json())
                .then(data => {
                    suggestionsList.innerHTML = "";

                    if (data.length === 0) {
                        suggestionsList.style.display = "none";
                        return;
                    }

                    const limitedData = data.slice(0, 10);

                    limitedData.forEach(item => {
                        const div = document.createElement("div");
                        div.classList.add("list-group-item", "list-group-item-action", "cie-item");
                        div.textContent = `${item.clave} - ${item.descripcion}`;
                        div.dataset.id = item.id;

                        div.addEventListener("click", function () {
                            addSelectedCie(item);
                            suggestionsList.style.display = "none";
                        });

                        suggestionsList.appendChild(div);
                    });

                    suggestionsList.style.display = "block";
                })
                .catch(error => console.error("Error en la búsqueda:", error));
        });

        function addSelectedCie(item) {
            if (document.querySelector(`#selected-cies input[value="${item.id}"]`)) {
                return;
            }

            const input = document.createElement("input");
            input.type = "hidden";
            input.name = "cie_data[]";
            input.value = JSON.stringify({ id: item.id, clave: item.clave });

            const span = document.createElement("span");
            span.textContent = `${item.clave} - ${item.descripcion} `;
            span.classList.add("badge", "bg-light", "text-dark", "border", "me-2", "p-2", "d-inline-block", "mb-2");
            const removeBtn = document.createElement("button");
            removeBtn.type = "button";
            removeBtn.innerHTML = '<i class="fas fa-trash-alt"></i>';
            removeBtn.classList.add("btn", "btn-sm", "btn-outline-danger", "ms-1");

            removeBtn.style.lineHeight = "1";
            removeBtn.setAttribute("aria-label", "Eliminar");
            removeBtn.addEventListener("click", function () {
                input.remove();
                span.remove();
            });


            span.appendChild(removeBtn);
            selectedCies.appendChild(input);
            selectedCies.appendChild(span);

            searchInput.value = "";
        }
    }
    
function runInitializers(context) {
    if (!(context instanceof HTMLElement)) return;

    if (context.dataset.initialized === "1") {
        console.log("Ya inicializado:", context);
        return;
    }

    initializeFormLogic(context);
    initializeCieSearch(context);

    context.dataset.initialized = "1";
    console.log("Inicializado:", context);
}

// Al cargar la página
document.addEventListener("DOMContentLoaded", function () {
    runInitializers(document.body);
    console.log("Init: pagina");
});

// Cuando se abre un modal -> siempre inicializar si no está marcado
$(document).on('shown.bs.modal', function (e) {
    const modalContent = e.target.querySelector('.modal-content');
    if (modalContent) {
        runInitializers(modalContent); // ahora siempre revisa el flag
        console.log("Init: modal");
    }
});

// Inicializar contenido nuevo tras AJAX
$(document).on('ajaxComplete', function () {
    const newContent = document.querySelectorAll('[data-init]:not([data-initialized="1"])');
    newContent.forEach(el => {
        runInitializers(el);
        console.log("Init: ajax ->", el);
    });
});

// Al cerrar el modal -> quitar flag y limpiar TinyMCE
$(document).on('hidden.bs.modal', function (e) {
    const modalContent = e.target.querySelector('.modal-content');
    if (modalContent) {
        delete modalContent.dataset.formLogicInitialized;
        delete modalContent.dataset.recipeLogicInitialized;
        delete modalContent.dataset.cieLogicInitialized;
        delete modalContent.dataset.initialized;
    }

    tinymce.remove('.receta-descripcion-tinymce');
});
</script>

<style>

    #cie-suggestions .cie-item {
        /* color: white; */
        color: #212529;
    background-color: #f8f9fa;
        padding: 10px;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    #cie-suggestions .cie-item:hover {
        /* background-color: #6c757d; */
        background-color: #e2e6ea;
    }
    .textarea-box {
        padding: 8px 10px;
        min-height: 120px;
        overflow-y: auto;
        resize: vertical;
        border: 1px solid #ced4da;
        border-radius: 4px;
        /* white-space: pre-wrap; */
        outline: none;
         font-family: Calibri, Arial, sans-serif;
    }

</style>