<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Producto Entity
 *
 * @property int $id
 * @property int|null $cantidad
 * @property int $categoria_id
 * @property string|null $descripcion
 * @property string|null $estado
 * @property \Cake\I18n\Date $fecha_ingreso
 * @property \Cake\I18n\Date|null $fecha_vencimiento
 * @property string $nombre
 * @property string $precio
 * @property int $proveedor_id
 * @property int|null $stock_minimo
 * @property string|null $ubicacion
 *
 * @property \App\Model\Entity\Categoria $categoria
 * @property \App\Model\Entity\Proveedor $proveedor
 * @property \App\Model\Entity\Transaccione[] $transacciones
 */
class Producto extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'cantidad' => true,
        'categoria_id' => true,
        'descripcion' => true,
        'estado' => true,
        'fecha_ingreso' => true,
        'fecha_vencimiento' => true,
        'nombre' => true,
        'precio' => true,
        'proveedor_id' => true,
        'stock_minimo' => true,
        'ubicacion' => true,
        'categoria' => true,
        'proveedor' => true,
        'transacciones' => true,
    ];
}
