<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * HistoriasClinica Entity
 *
 * @property int $id
 * @property int|null $paciente_id
 * @property string|null $medicacion
 * @property string|null $alergias
 * @property string|null $enfermedades
 * @property string|null $dni
 * @property \Cake\I18n\Date $fecha_nacimiento
 * @property int|null $edad
 * @property int|null $departamento_id
 * @property string|null $sexo
 * @property string|null $tipo_orden
 * @property int|null $user_id
 * @property string|null $como_entero
 * @property string|null $obs_administrativas
 * @property string|null $ocupacion
 * @property \Cake\I18n\DateTime $created
 * @property \Cake\I18n\DateTime $modified
 *
 * @property \App\Model\Entity\Paciente $paciente
 * @property \App\Model\Entity\Documento[] $documentos
 * @property \App\Model\Entity\Consulta[] $consultas
 * @property \App\Model\Entity\ExamenesFisico[] $examenes_fisicos
 */
class HistoriasClinica extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'paciente_id' => true,
        'medicacion' => true,
        'alergias' => true,
        'enfermedades' => true,
        'dni' => true,
        'fecha_nacimiento' => true,
        'edad' => true,
        'departamento_id' => true,
        'sexo' => true,
        'tipo_orden' => true,
        'user_id' => true,
        'como_entero' => true,
        'obs_administrativas' => true,
        'ocupacion' => true,
        'created' => true,
        'modified' => true,
        'paciente' => true,
        'documentos' => true,
        'consultas' => true,
        'examenes_fisicos' => true,
    ];
}
